clc;
close all;
%% Load 10 identical simulated Cohen fine crackles here 
load SF1_Cohen
load SF2_Cohen
load SF3_Cohen
load SF4_Cohen
load SF5_Cohen
load SF6_Cohen
load SF7_Cohen
load SF8_Cohen
load SF9_Cohen
load SF10_Cohen
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SF1_Cohen       = [zeros(1,1000),SF1_Cohen,zeros(1,Signal_length-(1000+length(SF1_Cohen)))];
SF2_Cohen       = [zeros(1,3000),SF2_Cohen,zeros(1,Signal_length-(3000+length(SF2_Cohen)))];
SF3_Cohen       = [zeros(1,7000),SF3_Cohen,zeros(1,Signal_length-(7000+length(SF3_Cohen)))];
SF4_Cohen       = [zeros(1,12000),SF4_Cohen,zeros(1,Signal_length-(12000+length(SF4_Cohen)))];
SF5_Cohen       = [zeros(1,14000),SF5_Cohen,zeros(1,Signal_length-(14000+length(SF5_Cohen)))];
SF6_Cohen       = [zeros(1,17000),SF6_Cohen,zeros(1,Signal_length-(17000+length(SF6_Cohen)))];
SF7_Cohen       = [zeros(1,20000),SF7_Cohen,zeros(1,Signal_length-(20000+length(SF7_Cohen)))];
SF8_Cohen       = [zeros(1,23000),SF8_Cohen,zeros(1,Signal_length-(23000+length(SF8_Cohen)))];
SF9_Cohen       = [zeros(1,27500),SF9_Cohen,zeros(1,Signal_length-(27500+length(SF9_Cohen)))];
SF10_Cohen      = [zeros(1,30000),SF10_Cohen,zeros(1,Signal_length-(30000+length(SF10_Cohen)))];
Ten_identical_simulated_Cohen_fine_crackles         = SF1_Cohen+SF2_Cohen+SF3_Cohen+SF4_Cohen+SF5_Cohen+SF6_Cohen+SF7_Cohen+SF8_Cohen+SF9_Cohen+SF10_Cohen;
Ten_identical_simulated_Cohen_fine_crackles         = Ten_identical_simulated_Cohen_fine_crackles(1:end);
%% Plot
figure
plot(Ten_identical_simulated_Cohen_fine_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
%%
text(1150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(250,.85,'SF1-C','fontsize',8,'FontWeight','bold')
text(3150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.85,'SF2-C','fontsize',8,'FontWeight','bold')
text(7150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(7000,.85,'SF3-C','fontsize',8,'FontWeight','bold')
text(12150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(11150,.85,'SF4-C','fontsize',8,'FontWeight','bold')
text(14150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.85,'SF5-C','fontsize',8,'FontWeight','bold')
text(17150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.85,'SF6-C','fontsize',8,'FontWeight','bold')
text(20150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.85,'SF7-C','fontsize',8,'FontWeight','bold')
text(23150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.85,'SF8-C','fontsize',8,'FontWeight','bold')
text(27650,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(26500,.85,'SF9-C','fontsize',8,'FontWeight','bold')
text(30150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(29800,.85,'SF10-C','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 identical simulated Cohen fine crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
xlim([0 Signal_length]);
ylim([-1 1]);
